#!/bin/bash
set -e

# 1. Create and configure the TUN interface
ip tuntap add dev tun0 mode tun || true
ip addr flush dev tun0
ip addr add 198.18.0.1/24 dev tun0
ip link set dev tun0 up

# IP forwarding rules - outline
# For TCP
iptables -t mangle -A OUTPUT -p tcp -m multiport --dports 80,443,8080,3128,7713,7714,7715,7716,10834,10835 -j MARK --set-mark 1

# For UDP
iptables -t mangle -A OUTPUT -p udp -m multiport --dports 80,443,8080,3128,7713,7714,7715,7716,10834,10835 -j MARK --set-mark 1

echo "100 http_traffic" >> /etc/iproute2/rt_tables

ip rule add fwmark 1 table http_traffic

ip route add default via 198.18.0.1 dev tun0 table http_traffic



# 7. NAT outgoing through tun0 to ensure correct source addressing
iptables -t nat -A POSTROUTING -o tun0 -j MASQUERADE

# 8. Launch tun2socks to proxy all marked traffic through the upstream SOCKS5 server
exec tun2socks --device tun0 --proxy socks5://ZybfuW:Ce8T18pN@195.42.232.39:13398
